/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trees.growers;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.class_1936;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_244;
import net.minecraft.class_251;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3341;
import net.minecraft.class_3481;
import net.minecraft.class_3499;
import net.minecraft.class_3614;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_5281;
import net.minecraft.class_5821;

public class SnowTreePlacer
extends class_3031<class_4643> {
    public SnowTreePlacer(Codec<class_4643> p_67201_) {
        super(p_67201_);
    }

    public static boolean isFree(class_3746 p_67263_, class_2338 p_67264_) {
        return SnowTreePlacer.validTreePos(p_67263_, p_67264_) || p_67263_.method_16358(p_67264_, p_67281_ -> p_67281_.method_26164(class_3481.field_15475));
    }

    private static boolean isVine(class_3746 p_67278_, class_2338 p_67279_) {
        return p_67278_.method_16358(p_67279_, p_67276_ -> p_67276_.method_27852(class_2246.field_10597));
    }

    private static boolean isBlockWater(class_3746 p_67283_, class_2338 p_67284_) {
        return p_67283_.method_16358(p_67284_, p_67271_ -> p_67271_.method_27852(class_2246.field_10382));
    }

    public static boolean isAirOrLeaves(class_3746 p_67268_, class_2338 p_67269_) {
        return p_67268_.method_16358(p_67269_, p_67266_ -> p_67266_.method_26215() || p_67266_.method_26164(class_3481.field_15503));
    }

    private static boolean isReplaceablePlant(class_3746 p_67289_, class_2338 p_67290_) {
        return p_67289_.method_16358(p_67290_, p_160551_ -> {
            class_3614 material = p_160551_.method_26207();
            return material == class_3614.field_15956;
        });
    }

    public static boolean isBlockUnderValid(class_3746 reader, class_2338 pos) {
        return reader.method_16358(pos, state -> state.method_26164(class_3481.field_29823)) || reader.method_16358(pos, state -> state.method_26164(class_3481.field_29822));
    }

    private static void setBlockKnownShape(class_1945 p_67257_, class_2338 p_67258_, class_2680 p_67259_) {
        p_67257_.method_8652(p_67258_, p_67259_, 19);
    }

    public static boolean validTreePos(class_3746 p_67273_, class_2338 p_67274_) {
        return SnowTreePlacer.isAirOrLeaves(p_67273_, p_67274_) || SnowTreePlacer.isReplaceablePlant(p_67273_, p_67274_) || SnowTreePlacer.isBlockWater(p_67273_, p_67274_);
    }

    private boolean doPlace(class_5281 p_160511_, Random p_160512_, class_2338 p_160513_, BiConsumer<class_2338, class_2680> p_160514_, BiConsumer<class_2338, class_2680> p_160515_, class_4643 p_160516_) {
        int i = p_160516_.field_24136.method_26993(p_160512_);
        int j = p_160516_.field_24135.method_26989(p_160512_, i, p_160516_);
        int k = i - j;
        int l = p_160516_.field_24135.method_23452(p_160512_, k);
        if (p_160513_.method_10264() >= p_160511_.method_31607() + 1 && p_160513_.method_10264() + i + 1 <= p_160511_.method_31600()) {
            if (!SnowTreePlacer.isBlockUnderValid((class_3746)p_160511_, p_160513_.method_10074())) {
                return false;
            }
            OptionalInt optionalint = p_160516_.field_24137.method_27377();
            int i1 = this.getMaxFreeTreeHeight((class_3746)p_160511_, i, p_160513_, p_160516_);
            if (i1 >= i || optionalint.isPresent() && i1 >= optionalint.getAsInt()) {
                List list = p_160516_.field_24136.method_26991((class_3746)p_160511_, p_160514_, p_160512_, i1, p_160513_, p_160516_);
                list.forEach(p_160539_ -> p_160516_.field_24135.method_27385((class_3746)p_160511_, p_160515_, p_160512_, p_160516_, i1, p_160539_, j, l));
                return true;
            }
            return false;
        }
        return false;
    }

    private int getMaxFreeTreeHeight(class_3746 p_67216_, int p_67217_, class_2338 p_67218_, class_4643 p_67219_) {
        class_2338.class_2339 blockpos$mutableblockpos = new class_2338.class_2339();
        for (int i = 0; i <= p_67217_ + 1; ++i) {
            int j = p_67219_.field_24137.method_27378(p_67217_, i);
            for (int k = -j; k <= j; ++k) {
                for (int l = -j; l <= j; ++l) {
                    blockpos$mutableblockpos.method_25504((class_2382)p_67218_, k, i, l);
                    if (SnowTreePlacer.isFree(p_67216_, (class_2338)blockpos$mutableblockpos) && (p_67219_.field_24138 || !SnowTreePlacer.isVine(p_67216_, (class_2338)blockpos$mutableblockpos))) continue;
                    return i - 2;
                }
            }
        }
        return p_67217_;
    }

    protected void method_13153(class_1945 p_67221_, class_2338 p_67222_, class_2680 p_67223_) {
        SnowTreePlacer.setBlockKnownShape(p_67221_, p_67222_, p_67223_);
    }

    public final boolean method_13151(class_5821<class_4643> p_160530_) {
        class_5281 worldgenlevel = p_160530_.method_33652();
        Random random = p_160530_.method_33654();
        class_2338 blockpos = p_160530_.method_33655();
        class_4643 treeconfiguration = (class_4643)p_160530_.method_33656();
        HashSet set = Sets.newHashSet();
        HashSet set1 = Sets.newHashSet();
        HashSet set2 = Sets.newHashSet();
        BiConsumer<class_2338, class_2680> biconsumer = (p_160555_, p_160556_) -> {
            set.add(p_160555_.method_10062());
            worldgenlevel.method_8652(p_160555_, p_160556_, 19);
        };
        BiConsumer<class_2338, class_2680> biconsumer1 = (p_160548_, p_160549_) -> {
            set1.add(p_160548_.method_10062());
            worldgenlevel.method_8652(p_160548_, p_160549_, 19);
        };
        BiConsumer<class_2338, class_2680> biconsumer2 = (p_160543_, p_160544_) -> {
            set2.add(p_160543_.method_10062());
            worldgenlevel.method_8652(p_160543_, p_160544_, 19);
        };
        boolean flag = this.doPlace(worldgenlevel, random, blockpos, biconsumer, biconsumer1, treeconfiguration);
        if (!(!flag || set.isEmpty() && set1.isEmpty())) {
            if (!treeconfiguration.field_21290.isEmpty()) {
                ArrayList list = Lists.newArrayList((Iterable)set);
                ArrayList list1 = Lists.newArrayList((Iterable)set1);
                list.sort(Comparator.comparingInt(class_2382::method_10264));
                list1.sort(Comparator.comparingInt(class_2382::method_10264));
                treeconfiguration.field_21290.forEach(p_160528_ -> p_160528_.method_23469((class_3746)worldgenlevel, biconsumer2, random, list, list1));
            }
            return class_3341.method_35411((Iterable)Iterables.concat((Iterable)set, (Iterable)set1, (Iterable)set2)).map(p_160521_ -> {
                class_251 discretevoxelshape = SnowTreePlacer.updateLeaves((class_1936)worldgenlevel, p_160521_, set, set2);
                class_3499.method_20532((class_1936)worldgenlevel, (int)3, (class_251)discretevoxelshape, (int)p_160521_.method_35415(), (int)p_160521_.method_35416(), (int)p_160521_.method_35417());
                return true;
            }).orElse(false);
        }
        return false;
    }

    private static class_251 updateLeaves(class_1936 p_67203_, class_3341 p_67204_, Set<class_2338> p_67205_, Set<class_2338> p_67206_) {
        ArrayList list = Lists.newArrayList();
        class_244 discretevoxelshape = new class_244(p_67204_.method_35414(), p_67204_.method_14660(), p_67204_.method_14663());
        int i = 6;
        for (int j = 0; j < 6; ++j) {
            list.add(Sets.newHashSet());
        }
        class_2338.class_2339 blockpos$mutableblockpos = new class_2338.class_2339();
        for (class_2338 blockpos : Lists.newArrayList(p_67206_)) {
            if (!p_67204_.method_14662((class_2382)blockpos)) continue;
            discretevoxelshape.method_1049(blockpos.method_10263() - p_67204_.method_35415(), blockpos.method_10264() - p_67204_.method_35416(), blockpos.method_10260() - p_67204_.method_35417());
        }
        for (class_2338 blockpos1 : Lists.newArrayList(p_67205_)) {
            if (p_67204_.method_14662((class_2382)blockpos1)) {
                discretevoxelshape.method_1049(blockpos1.method_10263() - p_67204_.method_35415(), blockpos1.method_10264() - p_67204_.method_35416(), blockpos1.method_10260() - p_67204_.method_35417());
            }
            for (class_2350 direction : class_2350.values()) {
                class_2680 blockstate;
                blockpos$mutableblockpos.method_25505((class_2382)blockpos1, direction);
                if (p_67205_.contains(blockpos$mutableblockpos) || !(blockstate = p_67203_.method_8320((class_2338)blockpos$mutableblockpos)).method_28498((class_2769)class_2741.field_12541)) continue;
                ((Set)list.get(0)).add(blockpos$mutableblockpos.method_10062());
                SnowTreePlacer.setBlockKnownShape((class_1945)p_67203_, (class_2338)blockpos$mutableblockpos, (class_2680)blockstate.method_11657((class_2769)class_2741.field_12541, (Comparable)Integer.valueOf(1)));
                if (!p_67204_.method_14662((class_2382)blockpos$mutableblockpos)) continue;
                discretevoxelshape.method_1049(blockpos$mutableblockpos.method_10263() - p_67204_.method_35415(), blockpos$mutableblockpos.method_10264() - p_67204_.method_35416(), blockpos$mutableblockpos.method_10260() - p_67204_.method_35417());
            }
        }
        for (int l = 1; l < 6; ++l) {
            Set set = (Set)list.get(l - 1);
            Set set1 = (Set)list.get(l);
            for (class_2338 blockpos2 : set) {
                if (p_67204_.method_14662((class_2382)blockpos2)) {
                    discretevoxelshape.method_1049(blockpos2.method_10263() - p_67204_.method_35415(), blockpos2.method_10264() - p_67204_.method_35416(), blockpos2.method_10260() - p_67204_.method_35417());
                }
                for (class_2350 direction1 : class_2350.values()) {
                    int k;
                    class_2680 blockstate1;
                    blockpos$mutableblockpos.method_25505((class_2382)blockpos2, direction1);
                    if (set.contains(blockpos$mutableblockpos) || set1.contains(blockpos$mutableblockpos) || !(blockstate1 = p_67203_.method_8320((class_2338)blockpos$mutableblockpos)).method_28498((class_2769)class_2741.field_12541) || (k = ((Integer)blockstate1.method_11654((class_2769)class_2741.field_12541)).intValue()) <= l + 1) continue;
                    class_2680 blockstate2 = (class_2680)blockstate1.method_11657((class_2769)class_2741.field_12541, (Comparable)Integer.valueOf(l + 1));
                    SnowTreePlacer.setBlockKnownShape((class_1945)p_67203_, (class_2338)blockpos$mutableblockpos, blockstate2);
                    if (p_67204_.method_14662((class_2382)blockpos$mutableblockpos)) {
                        discretevoxelshape.method_1049(blockpos$mutableblockpos.method_10263() - p_67204_.method_35415(), blockpos$mutableblockpos.method_10264() - p_67204_.method_35416(), blockpos$mutableblockpos.method_10260() - p_67204_.method_35417());
                    }
                    set1.add(blockpos$mutableblockpos.method_10062());
                }
            }
        }
        return discretevoxelshape;
    }
}

